unit WinForm;
{*=====================================================================
  Project:   PcxView.bdsproj

  File:      WinForm1.pas

  Summary:	 A Simple PCX-viewer to demonstrate the using of PCXClass.

---------------------------------------------------------------------
  This file is submitted by:

	 endresy@axelero.hu
	 Endre I. Simay,
	 Hungary


THIS CODE AND INFORMATION ARE PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A
PARTICULAR PURPOSE.
=====================================================================*}

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data,
  PcxClass
  ;

type
  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    Panel1: System.Windows.Forms.Panel;
    PictureBox1: System.Windows.Forms.PictureBox;
    Button1: System.Windows.Forms.Button;
    TextBox1: System.Windows.Forms.TextBox;
    OpenFileDialog1: System.Windows.Forms.OpenFileDialog;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    function open_and_view : boolean;
  public
    PCXreader : PCX_Reader;
    constructor Create;
  end;

implementation

uses
  System.Globalization;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
begin
  Self.OpenFileDialog1 := System.Windows.Forms.OpenFileDialog.Create;
  Self.Panel1 := System.Windows.Forms.Panel.Create;
  Self.PictureBox1 := System.Windows.Forms.PictureBox.Create;
  Self.Button1 := System.Windows.Forms.Button.Create;
  Self.TextBox1 := System.Windows.Forms.TextBox.Create;
  Self.Panel1.SuspendLayout;
  Self.SuspendLayout;
  // 
  // OpenFileDialog1
  // 
  Self.OpenFileDialog1.Filter := 'PCX|*.pcx';
  // 
  // Panel1
  //
  Self.Panel1.Anchor := (System.Windows.Forms.AnchorStyles((((System.Windows.Forms.AnchorStyles.Top
      or System.Windows.Forms.AnchorStyles.Bottom) or System.Windows.Forms.AnchorStyles.Left)
      or System.Windows.Forms.AnchorStyles.Right)));
  Self.Panel1.AutoScroll := True;
  Self.Panel1.Controls.Add(Self.PictureBox1);
  Self.Panel1.Location := System.Drawing.Point.Create(8, 40);
  Self.Panel1.Name := 'Panel1';
  Self.Panel1.Size := System.Drawing.Size.Create(272, 216);
  Self.Panel1.TabIndex := 2;
  // 
  // PictureBox1
  // 
  Self.PictureBox1.Location := System.Drawing.Point.Create(8, 8);
  Self.PictureBox1.Name := 'PictureBox1';
  Self.PictureBox1.SizeMode := System.Windows.Forms.PictureBoxSizeMode.AutoSize;
  Self.PictureBox1.TabIndex := 0;
  Self.PictureBox1.TabStop := False;
  // 
  // Button1
  // 
  Self.Button1.Location := System.Drawing.Point.Create(8, 8);
  Self.Button1.Name := 'Button1';
  Self.Button1.TabIndex := 0;
  Self.Button1.Text := 'Button1';
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // TextBox1
  // 
  Self.TextBox1.Location := System.Drawing.Point.Create(144, 8);
  Self.TextBox1.Name := 'TextBox1';
  Self.TextBox1.Size := System.Drawing.Size.Create(104, 20);
  Self.TextBox1.TabIndex := 1;
  Self.TextBox1.Text := '';
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(292, 273);
  Self.Controls.Add(Self.TextBox1);
  Self.Controls.Add(Self.Button1);
  Self.Controls.Add(Self.Panel1);
  Self.Name := 'TWinForm';
  Self.Text := 'PCXview for Delphi.NET by E.I.Simay';
  Self.Panel1.ResumeLayout(False);
  Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
  PCXreader := PCX_Reader.Create;
end;

procedure TWinForm.Button1_Click(sender: System.Object; e: System.EventArgs);
begin
  if (openFileDialog1.ShowDialog = System.Windows.Forms.DialogResult.OK) then
    begin
      if ( not open_and_view) then
        begin
         // a simple error-recording
         if (PCXreader.PCX_ErrorNumber <> 0) then
          begin
            MessageBox.Show(PCXreader.PCX_ErrorString + ' Sorry', 'PCXview Error',
                                    MessageBoxButtons.OK);
		      end
          else
          begin
            MessageBox.Show('Problem with picture path or format.' + ' Sorry', 'Pictureview Error',
                                    MessageBoxButtons.OK);
		      end;
        end;
      TextBox1.Text := 'H='+pictureBox1.Height.ToString+'; W='+pictureBox1.Width.ToString;
    end;
end;

function TWinform.open_and_view : boolean;
var
 fname : string;
begin
  fname := openFileDialog1.FileName;
  Result := true;
  if (fname<> '') then
  begin
    try
      try
        if (pictureBox1.Image <> nil) then
          begin
            pictureBox1.Image.Dispose;
          end;
        pictureBox1.Image := Image.FromStream(PCXreader.FromFile(fname));
      except
        Result := false;
      end;
    except
      Result := false;
    end;
  end
  else
    begin
      Result := false;
    end;
end;

end.
